/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.BaselineExtractor;
import net.java.dev.designgridlayout.ComponentHelper;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.IExtractor;
import net.java.dev.designgridlayout.IHideable;
import net.java.dev.designgridlayout.IRowItem;
import net.java.dev.designgridlayout.LabelAlignment;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.OrientationPolicy;
import net.java.dev.designgridlayout.PrefHeightExtractor;

abstract class AbstractRow
implements IHideable {
    private Container _parent;
    private HeightGrowPolicy _heightTester;
    private OrientationPolicy _orientation;
    private boolean _unrelatedGap = false;
    private int _vgap = 0;
    private int _baseline;
    private int _height;
    private double _growWeight = -1.0;
    private int _actualHeight;
    private int _hidden = 0;

    AbstractRow() {
    }

    @Override
    public final void show() {
        if (this._hidden > 0) {
            --this._hidden;
            if (this._hidden == 0) {
                for (IRowItem iRowItem : this.allItems()) {
                    iRowItem.show();
                }
            }
        }
    }

    @Override
    public final void hide() {
        if (this._hidden == 0) {
            for (IRowItem iRowItem : this.allItems()) {
                iRowItem.hide();
            }
        }
        ++this._hidden;
    }

    final void init(Container parent, HeightGrowPolicy heightTester, OrientationPolicy orientation) {
        this._parent = parent;
        this._heightTester = heightTester;
        this._orientation = orientation;
    }

    protected final Container parent() {
        return this._parent;
    }

    protected final HeightGrowPolicy growPolicy() {
        return this._heightTester;
    }

    protected final OrientationPolicy orientation() {
        return this._orientation;
    }

    final void setUnrelatedGap() {
        this._unrelatedGap = true;
    }

    final boolean hasUnrelatedGap() {
        return this._unrelatedGap;
    }

    final void vgap(int vgap) {
        this._vgap = vgap;
    }

    final int vgap() {
        return this._hidden == 0 ? this._vgap : 0;
    }

    final void init() {
        this._height = ComponentHelper.maxValues(this.allItems(), PrefHeightExtractor.INSTANCE);
        this._baseline = ComponentHelper.maxValues(this.allItems(), BaselineExtractor.INSTANCE);
        boolean fixedHeight = ComponentHelper.isFixedHeight(this._heightTester, this.items());
        if (fixedHeight || this._growWeight == -1.0) {
            this._growWeight = fixedHeight ? 0.0 : 1.0;
        }
    }

    void setLabelAlignment(LabelAlignment align) {
    }

    protected final int baseline() {
        return this._hidden == 0 ? this._baseline : 0;
    }

    final int height() {
        return this._hidden == 0 ? this._height : 0;
    }

    final void actualHeight(int height) {
        this._actualHeight = height;
    }

    final int actualHeight() {
        return this._hidden == 0 ? this._actualHeight : 0;
    }

    final void growWeight(double weight) {
        if (weight >= 0.0) {
            this._growWeight = weight;
        }
    }

    final double growWeight() {
        return this._hidden == 0 ? this._growWeight : 0.0;
    }

    int numGrids() {
        return 0;
    }

    void totalGrids(int totalGrids) {
    }

    int gridspan(int grid) {
        return 1;
    }

    int gridColumns(int grid) {
        return 0;
    }

    int labelWidth(int grid) {
        return 0;
    }

    int maxColumnWidth(int grid, int maxColumns, IExtractor extractor) {
        return 0;
    }

    int totalNonGridWidth(int hgap, int unrelhgap) {
        return 0;
    }

    int componentNonGridWidth() {
        return 0;
    }

    void forceComponentNonGridWidth(int width) {
    }

    int hgap() {
        return ComponentHelper.hgap(this.allItems(), this.parent());
    }

    int unrelhgap() {
        return ComponentHelper.unrelhgap(this.allItems(), this.parent());
    }

    int gridgap() {
        return 0;
    }

    boolean isEmpty() {
        return this.allItems().isEmpty();
    }

    JComponent leftComponent() {
        return this.allItems().isEmpty() ? null : this.allItems().get(0).component();
    }

    JComponent rightComponent() {
        return this.allItems().isEmpty() ? null : this.allItems().get(this.allItems().size() - 1).component();
    }

    void checkSpanRows() {
    }

    abstract List<? extends IRowItem> items();

    List<? extends IRowItem> allItems() {
        return this.items();
    }

    final int layout(LayoutHelper helper, int left, int hgap, int gridgap, int unrelhgap, int rowWidth, int gridsWidth, List<Integer> labelsWidth) {
        if (this._hidden == 0) {
            return this.layoutRow(helper, left, hgap, gridgap, unrelhgap, rowWidth, gridsWidth, labelsWidth);
        }
        return 0;
    }

    abstract int layoutRow(LayoutHelper var1, int var2, int var3, int var4, int var5, int var6, int var7, List<Integer> var8);
}

